;----------------------------------------
; 136kHz CW tranceiver clock gen.
;
; program name: 136KTRXGEN.asm
; ver: 0.10
; type: stand alone
; date: 2010/8/16
; copyright(c) 2009,2010  JJ1SUN
;----------------------------------------
; use Atmel ATtiny2313 (AT90S2313)
;     19.6608MHz OSC
;----------------------------------------
;I/O ports
; PORT B bit 0 TX clock output
;        bit 1 RX clock output
;        bit 2 
;        bit 3 
;        bit 4 
;        bit 5 
;        bit 6  
;        bit 7    
; PORT D bit 0 select 0 input
;        bit 1 select 1 input
;        bit 2
;        bit 3
;        bit 4 PSK input (1=nomal,0=invert)
;        bit 5 Key input (1=none,0=keydown)
;        bit 6 Tx/Rx (1=Rx,0=Tx)
;---------------------------------------
 .nolist
;
 .include "2313def.inc"
 .list
;---------------------------------------
; CPU register declaration
;
 .def	GP0		= r16	; general purpose 1
 .def	GP1		= r17	; general purpose 1
 .def	LOOPC1		= r18	; wait loop counter 1
 .def	LOOPC2		= r19	; wait loop counter 2
 .def	FRQSEL		= r20	; Frequency select parameter (not used)
				; (0=1/144,1=1/143,2=1/145)
 .def	CHSEL		= r21	; channel select 
 .def	TXRX		= r22	; TX/RX bit select (00000010=RX,00000001=TX)
 .def	TXRXMASK	= r23	; TX/RX bit masking data
 .def	TXRXINV		= r24	; TX/RX bit inverting data
 .def	WREG		= r25	; working register
 .def	MODESAVE	= r15	; mode 
;
;-----------------------------------------
;
 .equ	txbit	= 0B00000001
 .equ	rxbit	= 0B00000010
 .equ	mode0	= 0B00000000
 .equ	mode1	= 0B00000001
 .equ	mode2	= 0B00000010
 .equ	mode3	= 0B00000011
 .equ	pskin	= 0B00010000
 .equ	keyin	= 0B00100000
 .equ	txrxin	= 0B01000000
;
;----------------------------------------
 
 .cseg
;-----------------------------------------
; program starts here
;
 .org	0
	RJMP	RESET			; reset entry
;
;-----------------------------------------
; Program ID
;
ID:	.db	"136kHz TRX gen. ver.0.10 JJ1SUN "
;
;-----------------------------------------
;
RESET:
	LDI	WREG,RAMEND		; stack initialize
	OUT	SPL,WREG
;
	RCALL	INIT			; port & counter initialize
;
; mode selecter
;@@
MODESEL:
	IN	WREG,PIND
	ANDI	WREG,0B00000011
	MOV	MODESAVE,WREG	
	CPI	WREG,mode0
	BREQ	CH0			; ch0 mode
	CPI	WREG,mode1
	BREQ	CH1X			; ch1 mode
	CPI	WREG,mode2
	BREQ	CH2X			; ch2 mode
	RJMP	CH3			; ch3 mode
;
CH1X:
	RJMP	CH1
CH2X:
	RJMP	CH2
;
;---------------------------------------
; CH0  RX=1/144 (136.53kHz)  
;      TX=1/144 (136.53kHz)
;
CH0:
	RCALL	SWSENSE			; swich and mode sense (19+3)
	LDI	TXRXMASK,0B00000011
	LDI	WREG,0B00000011		; on data
	RCALL	OSCOUT			; TX/RX clock out (8+3)
;
	LDI	LOOPC1,12		; 3*12 = 36
CH002:
	DEC	LOOPC1
	BRNE	CH002
	NOP
;
;   (72 clock)
;
	RCALL	SWSENSE			; (19+3)
	LDI	TXRXMASK,0B00000011
	LDI	WREG,0B00000000		; off data
	RCALL	OSCOUT			; (8+3)
;
	RCALL	CHECKMODE		; (8+3)
;
	LDI	LOOPC1,7		; 3*7 = 21
CH003:
	DEC	LOOPC1
	BRNE	CH003
	NOP
;
	NOP
	NOP
	RJMP	CH0			; (2)
;  (72 clock)	
;---------------------------------------
; CH1  RX=1/143 (137.49kHz)  
;      TX=1/143 (137.49kHz)
;
CH1:
	RCALL	SWSENSE			; swich and mode sense
	LDI	TXRXMASK,0B00000011
	LDI	WREG,0B00000011		; on data
	RCALL	OSCOUT			; TX/RX clock out
;
	LDI	LOOPC1,11		; 3*11 = 33
CH102:
	DEC	LOOPC1
	BRNE	CH102
	NOP
;
	NOP
	NOP
;   (71 clock)
;
	RCALL	SWSENSE
	LDI	TXRXMASK,0B00000011
	LDI	WREG,0B00000000		; off data
	RCALL	OSCOUT
;
	RCALL	CHECKMODE
;
	LDI	LOOPC1,7		; 3*7 = 21
CH103:
	DEC	LOOPC1
	BRNE	CH103
	NOP
;
	NOP
	NOP
	RJMP	CH1
;  (72 clock)	
;---------------------------------------
; CH2  RX=1/145 (135.59kHz)  
;      TX=1/144 (136.53kHz)
;
CH2:
	RCALL	SWSENSE			; swich and mode sense
	NOP
	LDI	WREG,0B00000011		; on data
	RCALL	OSCOUT			; TX/RX clock out
;
	LDI	LOOPC1,12		; 3*12 = 36
CH202:
	DEC	LOOPC1
	BRNE	CH202
	NOP
;
;  (72 clock)
;
	RCALL	SWSENSE
	NOP
	LDI	WREG,0B00000000		; off data
	RCALL	OSCOUT
;
	RCALL	CHECKMODE
;
	CPI	TXRX,rxbit		; RX ?
	BREQ	CH204
CH204:
	LDI	LOOPC1,7		; 3*7 = 21
CH203:
	DEC	LOOPC1
	BRNE	CH203	
	NOP
;
	RJMP	CH2
;  (72 or 73 clock)	
;---------------------------------------
; CH3  RX=1/144 (136.53kHz)  
;      TX=1/143 (137.49kHz)
;
CH3:
	RCALL	SWSENSE			; swich and mode sense
	NOP
	LDI	WREG,0B00000011		; on data
	RCALL	OSCOUT			; TX/RX clock out
;
	LDI	LOOPC1,12		; 3*12 = 36
CH302:
	DEC	LOOPC1
	BRNE	CH302
	NOP
;
;  (72 clock)
;
	RCALL	SWSENSE
	NOP
	LDI	WREG,0B00000000		; off data
	RCALL	OSCOUT
;
	RCALL	CHECKMODE
;
	CPI	TXRX,rxbit		; RX ?
	BREQ	CH304
CH304:
	LDI	LOOPC1,6		; 3*6 = 18
CH303:
	DEC	LOOPC1
	BRNE	CH303	
	NOP
;
	NOP
	NOP
	RJMP	CH3
;  (71 or 72 clock)	
;---------------------------------------
; TX/RX clock out put
; (total 8 clock)
;
OSCOUT:
	AND	WREG,TXRX
	EOR	WREG,TXRXINV
	AND	WREG,TXRXMASK
	OUT	PORTB,WREG
	RET
;
;---------------------------------------
; Switch sense and flags set
; (total 19 clock)
SWSENSE:
	LDI	TXRX,txbit
	IN	WREG,PIND		; KEY & PSK sense
	ANDI	WREG,txrxin		; Tx/Rx
	BREQ	SWSENSE1		; Tx mode
	LDI	TXRX,rxbit
SWSENSE1:
	LDI	TXRXMASK,0B00000011	; Tx/Rx enable
	IN	WREG,PIND		; KEY
	ANDI	WREG,keyin		; Key down ?
	BREQ	SWSENSE2
	LDI	TXRXMASK,0B00000010	; rx enable tx disable
SWSENSE2:
	LDI	TXRXINV,0B00000000	; noninvert
	IN	WREG,PIND
	ANDI	WREG,pskin		; PSK
	BRNE	SWSENSE3
	LDI	TXRXINV,0B00000011	; invert
SWSENSE3:	
	RET				; 
;
;----------------------------------------
; Check mode change
; (total 8 clock)
;
CHECKMODE:
	IN	WREG,PIND
	ANDI	WREG,0B00000011		; channel no change ?
	CP	WREG,MODESAVE
	BRNE	CHECKMODE1
	RET				; 
;
CHECKMODE1:
	LDI	WREG,RAMEND		; stack initialize
	OUT	SPL,WREG
	RJMP	MODESEL			; mode chenged break
;
;---------------------------------------
; Ports and working register initialize
;
INIT:
	LDI	WREG,0B11111111		; port b output
	OUT	DDRB,WREG
	LDI	WREG,0B00000000
	OUT	PORTB,WREG		; TX,RX off
	LDI	WREG,0B00000000		; port D input
	OUT	DDRD,WREG
;
	LDI	TXRX,rxbit
	LDI	FRQSEL,0
	LDI	TXRXMASK,0B00000011	; Tx/Rx enable
	LDI	TXRXINV,0B00000000	; non invert
	RET
;
;----------------------------------------
;
;  end
;